﻿using System;
using System.Collections.Generic;

/// <summary>
///     Ten obiekt przechowuje kolekcję stron
/// </summary>
public class SiteList
{
    protected SortedList<int, WebSite> sites;

    public SiteList()
    {
        sites = new SortedList<int, WebSite>();
    }

    public int NextIndex
    {
        get
        {
            return sites.Count;
        }
    }

    public WebSite this[int index]
    {
        get
        {
            if (index > sites.Count)
                return (WebSite)null;

            return (WebSite)sites[index];
        }
        set
        {
            if (index < 10)
                sites[index] = value;
        }
    }

    public void Remove(int element)
    {
        sites.RemoveAt(element);
    }
}
